/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xpci32rg.h
 * -----------------------------------------------------------------*/

#ifndef XPCI32REG_H_INCLUDED
#define XPCI32REG_H_INCLUDED

#ifndef DOSW32
/*
// ** IMPORTANT **
// This is a Win32 - ONLY set of functions.
// All registry access routines in Pci32Reg.c are Unicode-compliant.  
// Use _TCHAR instead of char and _tcs... macros to keep them that way.
*/

#include <wchar.h>

#include <xtypedef.h>
#include <b_pci.h>    /* the device driver */

#include <xlasterr.h>

/*
// This MUST agree with DEV_VERSION in bx_ntpci.h or the program
// will NOT RUN (!!!!).  Thus compile times are important (!!!)
*/
#define CAPI_VERSION        DEV_VERSION

/*
// The first 5 functions are the main interface to the device-registry
*/

/* 1. Version check...returns BX_E_OK or error code.  #Ifdef _DEBUG => BX_E_OK  */
  bx_errtype BestXNTRegVersionCheck( void );

/* 2. The "real" BestXDevIdentifierGet() function  */
  bx_errtype EXPORT BestXNTRegDevIDGet( 
  bx_int32 dwVendorId,
  bx_int32 dwDeviceId,
  bx_int32 dwSubsysId,
  bx_int32 *pdwHPSlotId        /* returns HPSlotId */
                            );

/*
// 3. After getting a valid HPSlotId this function returns a name that
//    can be used in the call to CreateFile() to get a handle to the Device.
*/
  bx_errtype BestXNTRegDevNameGet( 
  bx_int32 pdwHPSlotId,
                            _TCHAR * pszUserBuffer,     /* returns "CreateFile()" name */
  bx_int32 * pdwBufferSize     /* returned val = # of bytes read */
                            );

/*
// 4. After successfully calling CreateFile() and getting a valid handle to the
//    device we need to claim ownership of the device.  
//    The uses for this mechanism are not fully developed yet.
*/
  bx_errtype BestXNTRegOwnerSet(
  bx_int32 dwHPSlotId,
  bx_int32 * pdwCurrOwnerProcessId
                            );

/*
// 5. On closing a device handle we release ownership
*/
  bx_errtype BestXNTRegOwnerClear(
  bx_int32 dwHPSlotId,
  bx_int32 * pdwCurrOwnerProcessId
                            );

/*
// These functions are exposed because we're not yet sure what we'll need.
*/
  bx_errtype EXPORT BestXNTRegDevEnumGet( 
  bx_int32 dwHPSlotId,
  bx_int32 * pdwDevNum     /* returned; index of dev. */
                            );

  bx_errtype BestXNTRegDWordGet( 
                            const _TCHAR * pcszValueName,
  bx_int32 dwDeviceEnum,
  bx_int32 *pdwValue
                            );

  bx_errtype BestXNTRegDWordSet( 
                            const _TCHAR * pcszValueName,
  bx_int32 dwDeviceEnum,
  bx_int32 dwValue
                            );

/*
// This function is not strictly required as the only 2 strings in the Pci Device
// Registry are "Version" and "Name", both of which are accessed by other functions
// (BestXNTRegVersionCheck() and BestXNTRegDevNameGet()).  
// This is exposed for future music.
*/
  bx_errtype BestXNTRegSzGet( 
                            const _TCHAR * pcszValueName,
  bx_int32 dwDeviceEnum,
                            _TCHAR * pszUserBuffer,
  bx_int32 * pdwBufferSize     /* returned val = # of bytes read */

);

#endif /* DOSW32 */                           

#endif    /* PCI32REG_H */
